'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Binary           'Binary wichtig fr LastModified !
Option Explicit

Private Sub Befehl75_Click()
    Beep
End Sub

Private Sub Aktualisierungen_drucken_Click()
On Error GoTo Err_Aktualisierungen_drucken_Click
    Dim dbs As Database, rst As Recordset
    
    Set dbs = CurrentDb
    Set rst = dbs.OpenRecordset("Abf_AktualisierungenJahr")
    
    If (rst.RecordCount = 0) Then
        rst.Close
        Set dbs = Nothing
        MsgBox "Es wurden noch keine Aktualisierungen durchgefhrt.", vbInformation, "Hinweis"
        Exit Sub
    End If
    
    rst.Close
    Set dbs = Nothing
    
    'Bericht ffnen
    TextEingabe = "Aktualisierungen"
    DoCmd.OpenForm "Aktualisierungen_Jahreswahl", acNormal
        
    
Exit_Aktualisierungen_drucken_Click:
    Exit Sub
    
Err_Aktualisierungen_drucken_Click:
    MsgBox err.Description
    Resume Exit_Aktualisierungen_drucken_Click

End Sub

Private Sub Button_Fehlermeldung_Click()
    If FehlerMeldung <> "" Then
        MsgBox FehlerMeldung, , "Fehlerbeschreibung", err.HelpFile, err.HelpContext
    Else
        MsgBox "Das Programm lief bisher fehlerfrei.", vbInformation, "Hinweis"
    End If
End Sub

Private Sub Button_Schliessen_Click()
On Error GoTo Err_Button_Schliessen_Click


    DoCmd.Close

Exit_Button_Schliessen_Click:
    Exit Sub

Err_Button_Schliessen_Click:
    MsgBox err.Description
    Resume Exit_Button_Schliessen_Click
    
End Sub

Private Sub Button_START_Click()
    
    Dim KatLoeschText As String
    
    Dim DatumVon As Date
    Dim DatumBis As Date
    
    Dim NummeroAllerKalender As Long
    
    'Gltigkeitsprfungen
    If (IsNull(Me.Datum_von.Value) Or (Trim(Me.Datum_von.Value) = "")) Then
        MsgBox "Bitte geben Sie ein Von-Datum ein!", vbCritical, "Fehler"
        Me.Datum_von.SetFocus
        Exit Sub
    End If
    If (IsNull(Me.Datum_bis.Value) Or (Trim(Me.Datum_bis.Value) = "")) Then
        MsgBox "Bitte geben Sie ein Bis-Datum ein!", vbCritical, "Fehler"
        Me.Datum_von.SetFocus
        Exit Sub
    End If
    
    'Prfung ob beide Termine im selben Jahr
    If Year(Me.Datum_von.Value) <> Year(Me.Datum_bis.Value) Then
        MsgBox "Von-Datum und Bis-Datum mssen im selben Jahr liegen!", vbCritical, "Fehler"
        Exit Sub
    End If
    
    
    'Prfung gesperrte Jahre
    If Year(Me.Datum_bis.Value) < Me.NichtVorJahr Then
        MsgBox "Gem Ihren Einstellungen drfen keine Jahre vor " & Me.NichtVorJahr & " gendert werden.", vbOKOnly + vbCritical, "Fehler"
        Exit Sub
    End If
    
    
    
    'Prfen, ob Tag-Von und Tag-Bis mit der Jahresauswahl gltige Datumswerte ergeben
    UpdateAbbruch = False
    'vorhanden Tests:
'''    Tag_von_LostFocus
'''    Tag_bis_LostFocus
    If UpdateAbbruch = True Then Exit Sub
    'Prfen, ob Von-Datum <= Bis-Datum ist
'''    DatumVon = DateSerial(Me.Jahresauswahl, Val(Mid(Me.Tag_von.Value, 4, 2)), Val(Left(Me.Tag_von.Value, 2)))
'''    DatumBis = DateSerial(Me.Jahresauswahl, Val(Mid(Me.Tag_bis.Value, 4, 2)), Val(Left(Me.Tag_bis.Value, 2)))
    DatumVon = DateSerial(Year(Datum_von), Month(Datum_von), Day(Datum_von))
    DatumBis = DateSerial(Year(Datum_bis), Month(Datum_bis), Day(Datum_bis))
    If DateDiff("d", DatumVon, DatumBis) < 0 Then
        MsgBox "Das Von-Datum liegt nach dem Bis-Datum.", vbOKOnly + vbCritical, "Fehler"
        Exit Sub
    End If
    
    
    On Error GoTo ErrorVariablenInitialisierung
    
    'ersten Hinweis fr den Benutzer ausgeben ------------------
    Me.Meldungsfeld.Caption = "System vorbereiten..."
    Me.Repaint
    
    'Variablen deklarieren -------------------------------------
    '...erfolgt im Extramodul
        
    FehlerMeldung = ""
    UpdateAbbruch = False
    
    'Anzeige "normalisieren"
    Me.Ergebnis_TermineFiltern.Caption = "?"
    Me.Ergebnis_TermineFiltern.ForeColor = "16711680"               'blau
    Me.Ergebnis_TermineAktualisieren.Caption = "?"
    Me.Ergebnis_TermineAktualisieren.ForeColor = "16711680"         'blau
    Me.Ergebnis_KategorieAktualisierung.Caption = "?"
    Me.Ergebnis_KategorieAktualisierung.ForeColor = "16711680"         'blau
    Me.Ergebnis_TerminePruefen.Caption = "?"
    Me.Ergebnis_TerminePruefen.ForeColor = "16711680"               'blau
    Me.Ergebnis_TermineLoeschen.Caption = "?"
    Me.Ergebnis_TermineLoeschen.ForeColor = "16711680"              'blau
    Me.Ergebnis_Kalender.Caption = "?"
    Me.Ergebnis_Kalender.ForeColor = "16711680"                     'blau
    Me.Pfeil_TermineFiltern.Visible = False
    Me.Pfeil_TermineAktualisieren.Visible = False
    Me.Pfeil_KategorieAktualisierung.Visible = False
    Me.Pfeil_TerminePruefen.Visible = False
    Me.Pfeil_TermineLoeschen.Visible = False
    Me.Pfeil_Kalender.Visible = False
    Me.TerminNummerAktuell.Caption = "..."
    Me.PruefenNummerAktuell.Caption = "..."
    Me.PruefenNummerGesamt.Caption = "..."
    Me.KategorieNummerAktuell.Caption = "..."
    Me.TerminLoeschenAktuell.Caption = "..."
    Me.TerminLoeschenGesamt.Caption = "..."
    Me.KalenderAktuell.Caption = "..."
    Me.KalenderGesamt.Caption = "..."
    Me.Meldungsfeld.Caption = "..."
    Me.TerminAktuellAnzeigen.Caption = ""
    
    'Button freigeben/sperren -----------------------------------
    Me.Button_STOP.Enabled = True
    Me.Button_STOP.SetFocus
    Me.Button_START.Enabled = False
    Me.Button_Schliessen.Enabled = False
    Me.Button_Fehlermeldung.Enabled = False
    Me.Aktualisierungen_drucken.Enabled = False

    'Tabellen Einstellungen/Kontakte/Termine ffnen -------------
    UpdateDatum = Now()
    Set dbs = CurrentDb
    Set rstEinstellungen = dbs.OpenRecordset("Einstellungen")

    'Update protokollieren --------------------------------------
    Set rstAktualisierungen = dbs.OpenRecordset("Aktualisierungen")
    rstAktualisierungen.AddNew
    rstAktualisierungen!Start = UpdateDatum
'''    rstAktualisierungen!Monat = Val(Mid(Me.Tag_bis.Value, 4, 2))    'wird ab 11/2011 nicht mehr bentigt... trotzdem weiterhin fllen
'''    rstAktualisierungen!TagVon = Me.Tag_von.Value
'''    rstAktualisierungen!TagBis = Me.Tag_bis.Value
'''    rstAktualisierungen!Jahr = Me.Jahresauswahl.Value
    rstAktualisierungen!Monat = Month(DatumBis)             'wird ab 11/2011 nicht mehr bentigt... trotzdem weiterhin fllen
    rstAktualisierungen!TagVon = DatumVon       '=====> Anpassen auf nur Tag.Monat.
    rstAktualisierungen!TagBis = DatumBis       '=====> Anpassen auf nur Tag.Monat.
    rstAktualisierungen!Jahr = Year(DatumBis)
    rstAktualisierungen!Anwender = Trim(Left(CurrentUser, 100))
    rstAktualisierungen!Status = "Unvollstndig"
    rstAktualisierungen.Update
        
    'Termine suchen/filtern =========================================================
    
'''''    'Terminordner suchen ---------------------------------------
'''''    Me.Meldungsfeld.Caption = "Terminordner suchen..."
'''''    Me.Pfeil_TermineFiltern.Visible = True
'''''    Me.Repaint
'''''    If (Trim(rstEinstellungen!Terminordner_Postfach) = "") Or (IsNull(rstEinstellungen!Terminordner_Postfach)) Then
'''''        Me.Meldungsfeld.Caption = "Bitte geben Sie in den Einstellungen ein Postfach fr den Terminordner ein!"
'''''        Me.Ergebnis_TermineFiltern.Caption = "Fehler"
'''''        Me.Ergebnis_TermineFiltern.ForeColor = "255"    ' Rot
'''''        FehlerMeldung = "(Keine Systeminformationen zu diesem Fehler.)"     '"Fllen", dami in der Db "Fehler" vermerkt wird
'''''        GoTo Ende_Button_START_Click
'''''    End If
'''''    If (Trim(rstEinstellungen!Terminordner_Ebene1) = "") Or (IsNull(rstEinstellungen!Terminordner_Ebene1)) Then
'''''        Me.Meldungsfeld.Caption = "Bitte geben Sie in den Einstellungen im Feld Termine-Unterordner1 einen Ordnernamen ein!"
'''''        Me.Ergebnis_TermineFiltern.Caption = "Fehler"
'''''        Me.Ergebnis_TermineFiltern.ForeColor = "255"    ' Rot
'''''        FehlerMeldung = "(Keine Systeminformationen zu diesem Fehler.)"     '"Fllen", dami in der Db "Fehler" vermerkt wird
'''''        GoTo Ende_Button_START_Click
'''''    End If
    
    'Versuchen Outlook zu ffnen --------------------------------
    On Error GoTo ErrorOutlookVerbindung
    Set olkAnw = Nothing                'Alte Referenzen freigeben
    Set meinNamespace = Nothing
    Set olkAnw = CreateObject("Outlook.Application")
    Set meinNamespace = olkAnw.GetNamespace("MAPI")
    
    olkVersion = olkAnw.Version             ' OL 1997       =   "8.02[...]"
                                            ' OL 2000 SP3   =   "9.0.0.6627"    (TEXT!)
                                            ' OL 2002       =   "10.    "
                                            ' OL 2003       =   "11.    "
                                            ' OL 2007 SP3   =   "12.0.0.6680"
                                            ' OL 2010 Prof  =   "14.0.  "
                                            ' OL 2013       =   "15.0.  "
                                            ' OL 2016       =   "16.0.  "
    'MsgBox olkVersion

    'Benutzername ermitteln ------------------------------------
    ' deaktiviert, da bei Abfrage des Benutzers eine irrefhrende Meldung von Outlook ausgegeben wird
    '-----------------------------------------------------------
    'rstAktualisierungen.Bookmark = rstAktualisierungen.LastModified
    'rstAktualisierungen.Edit
    'rstAktualisierungen!Anwender = Trim(Left((rstAktualisierungen!Anwender & " / " & meinNamespace.CurrentUser.Name), 100))
    'rstAktualisierungen.Update
    
    
    
    
    
    
Dim Ordner_ID As String
Dim Store_ID As String

NummeroAllerKalender = 0
    
'Aktivierte Kalender durchgehen
Set rstKalenderOrdner = dbs.OpenRecordset("SELECT * FROM Kalender WHERE Aktiv = True ORDER BY Name")
'1.) auf EntryID des Ordners prfen...
If (rstKalenderOrdner.RecordCount) = 0 Then
    'Achtung: Der folgende Meldungstext wird am Ende EXAKT ausgewertet, eine "Fehler"-Meldung abzufangen:
    Me.Meldungsfeld.Caption = "In den Einstellungen gibt es keinen 'aktiven' Kalender."
'''    Me.Ergebnis_TermineFiltern.Caption = "Fehler"
'''    Me.Ergebnis_TermineFiltern.ForeColor = "255"    ' Rot
    FehlerMeldung = "(Keine Systeminformationen verfgbar.)"     '"Fllen", dami in der Db "Fehler" vermerkt wird
    GoTo Ende_Button_START_Click
Else
    
    
    
    
    'Vorbereitungen
    '--------------
    
    'Alle Kontakte-Ordner in Outlook ermitteln und deren EntryID und StoreID in Arrays sammeln
    CoSuchen
    
    'Ab OL_2007 die Farbkategorien aus Outlook auslesen und bernehmen =================
    'ansonsten erfolgt der Kategorieabgleich in der Terminverarbeitung,
    'wo auch die Termin-Kategorien verarbeitet werden, die nicht in der Liste sind
    Me.Meldungsfeld.Caption = "Kategorien aktualisieren..."
    Me.Pfeil_KategorieAktualisierung.Visible = True
    Select Case Left(olkVersion, 2)
        Case "12", "13", "14", "15", "16", "17"         '17 schon prophylaktisch
            KategorienVonOutlook
            Me.Ergebnis_KategorieAktualisierung.Caption = "OK"
        Case Else
            Me.Ergebnis_KategorieAktualisierung.Caption = "(OK)"
    End Select
    Me.Ergebnis_KategorieAktualisierung.ForeColor = "32768"   ' Grn
    Me.Pfeil_KategorieAktualisierung.Visible = False
    Me.Repaint
    
    
    
    
    
    rstKalenderOrdner.MoveLast      'Auffllen
    rstKalenderOrdner.MoveFirst
    'KanlenderOrdner durchgehen
    Do While rstKalenderOrdner.EOF = False
        'Anzeige "normalisieren"
        Me.Ergebnis_TermineFiltern.Caption = "?"
        Me.Ergebnis_TermineFiltern.ForeColor = "16711680"               'blau
        Me.Ergebnis_TermineAktualisieren.Caption = "?"
        Me.Ergebnis_TermineAktualisieren.ForeColor = "16711680"         'blau
        'Me.Ergebnis_KategorieAktualisierung.Caption = "?"
        'Me.Ergebnis_KategorieAktualisierung.ForeColor = "16711680"         'blau
        Me.Ergebnis_TerminePruefen.Caption = "?"
        Me.Ergebnis_TerminePruefen.ForeColor = "16711680"               'blau
        Me.Ergebnis_TermineLoeschen.Caption = "?"
        Me.Ergebnis_TermineLoeschen.ForeColor = "16711680"              'blau
        Me.Ergebnis_Kalender.Caption = "?"
        Me.Ergebnis_Kalender.ForeColor = "16711680"                     'blau
        Me.Pfeil_TermineFiltern.Visible = False
        Me.Pfeil_TermineAktualisieren.Visible = False
        'Me.Pfeil_KategorieAktualisierung.Visible = False
        Me.Pfeil_TerminePruefen.Visible = False
        Me.Pfeil_TermineLoeschen.Visible = False
        Me.Pfeil_Kalender.Visible = False
        Me.TerminNummerAktuell.Caption = "..."
        Me.PruefenNummerAktuell.Caption = "..."
        Me.PruefenNummerGesamt.Caption = "..."
        Me.TerminLoeschenAktuell.Caption = "..."
        Me.TerminLoeschenGesamt.Caption = "..."
        Me.KalenderAktuell.Caption = "..."
        Me.KalenderGesamt.Caption = "..."
        Me.Meldungsfeld.Caption = "..."
        Me.TerminAktuellAnzeigen.Caption = ""
        'KalenderOrdner durchgehen
        Me.KalenderNameAktuell.Caption = rstKalenderOrdner!Name
        Me.Repaint
        Ordner_ID = rstKalenderOrdner!Kalender_ID
        Store_ID = rstKalenderOrdner!Store_ID
        
        On Error GoTo OrdnerNichtMehrGefunden       'falls die nchste Anweisung einen Fehler produziert
        Set meinTerminOrdner = meinNamespace.GetFolderFromID(Ordner_ID, Store_ID)
        If meinTerminOrdner = Empty Then
            GoTo OrdnerNichtMehrGefunden_Ueberspringen
OrdnerNichtMehrGefunden:
            'ohne weitere Fehlerbehandlung...
            Resume OrdnerNichtMehrGefunden_Ueberspringen
            'und weiter gehts...
OrdnerNichtMehrGefunden_Ueberspringen:
            Me.Meldungsfeld.Caption = "Der Kalender [" & rstKalenderOrdner!Pfad & "] wurde in Outlook nicht gefunden!"
            Me.Ergebnis_TermineFiltern.Caption = "Fehler"
            Me.Ergebnis_TermineFiltern.ForeColor = "255"    ' Rot
            FehlerMeldung = "(Keine Systeminformationen zu diesem Fehler.)"     '"Fllen", damit in der Db "Fehler" vermerkt wird
            GoTo Ende_Button_START_Click
        End If
    
    
    
    
'''''    'mit Postfach fr Termine verbinden ------------------------
'''''    On Error GoTo ErrorTerminPostfach
'''''    Set meinTerminPostfach = meinNamespace.Folders.Item(Trim(rstEinstellungen!Terminordner_Postfach))
'''''    'mit Unterordner 1 fr Termine verbinden -------------------
'''''    On Error GoTo ErrorTerminUnterordner1
'''''    Set meinTerminOrdner = meinTerminPostfach.Folders.Item(Trim(rstEinstellungen!Terminordner_Ebene1))
'''''    'evtl. mit Termin-Unterordner-2 verbinden --------------------
'''''    If Not IsNull(rstEinstellungen!Terminordner_Ebene2) Then
'''''        If (Trim(rstEinstellungen!Terminordner_Ebene2) <> "") Then
'''''            On Error GoTo ErrorTerminUnterordner2
'''''            Set meinTerminOrdner = meinTerminOrdner.Folders.Item(Trim(rstEinstellungen!Terminordner_Ebene2))
'''''        End If
'''''    End If
'''''    'evtl. mit Termin-Unterordner-3 verbinden --------------------
'''''    If Not IsNull(rstEinstellungen!Terminordner_Ebene3) Then
'''''        If (Trim(rstEinstellungen!Terminordner_Ebene3) <> "") Then
'''''            On Error GoTo ErrorTerminUnterordner3
'''''            Set meinTerminOrdner = meinTerminOrdner.Folders.Item(Trim(rstEinstellungen!Terminordner_Ebene3))
'''''        End If
'''''    End If
    
    
    If meinTerminOrdner.Items.Count = 0 Then
    'Folgende Meldung fr den Durchlauf mehrerer KalenderOrnder deaktiviert, damit nicht bei einem
    'Ordner in der Mitte ohne Termine abgebrochen wird
'        Me.Meldungsfeld.Caption = "Der in den Einstellungen angegeben Terminordner enthlt in Ihrem Outlook keine Eintrge!"
'        Me.Ergebnis_TermineFiltern.Caption = "Fehler"
'        Me.Ergebnis_TermineFiltern.ForeColor = "255"    ' Rot
'        FehlerMeldung = "(Keine Systeminformationen zu diesem Fehler.)"     '"Fllen", damit in der Db "Fehler" vermerkt wird
'        GoTo Ende_Button_START_Click
'    End If
    Else
'lfd_Nr merken, damit diese spter zum Termin eingetragen werden kann
AktKalender = rstKalenderOrdner!lfd_Nr







    
    'auf Abbruchwunsch reagieren
    DoEvents            'auf Mausklick reagieren
    'auf Abbruchwunsch reagieren -----------------------------------
    If (UpdateAbbruch = True) Then
        'Anzeige auf ABBRUCH stellen
        Me.Ergebnis_TermineFiltern.Caption = "Abbruch"
        'Me.Ergebnis_TermineFiltern.ForeColor = "32768"  ' Grn
        Me.Ergebnis_TermineFiltern.ForeColor = "255"    ' Rot
        Me.Pfeil_TermineFiltern.Visible = False
        Me.Repaint
        GoTo Ende_Button_START_Click
    Else
        'Anzeige auf OK stellen
        Me.Ergebnis_TermineFiltern.Caption = "OK"
        Me.Ergebnis_TermineFiltern.ForeColor = "32768"  ' Grn
        'Me.Ergebnis_TermineFiltern.ForeColor = "255"    ' Rot
        Me.Pfeil_TermineFiltern.Visible = False
        Me.Repaint
    End If
    
    Set meinTermin = meinTerminOrdner.Items.Item(1)
    VersionDesOutlook = meinTermin.OutlookVersion       'Version fr Sub merken!
    
    
    
    'Termine aktualisieren =============================================================
    Me.Pfeil_TermineAktualisieren.Visible = True
    Nummero = 0
    Me.Meldungsfeld.Caption = "Termine/Adressen aktualisieren..."
    Me.TerminNummerAktuell.Caption = Nummero
    Me.Repaint
    ' 1 Sekunde abziehen, damit die Anzeige zu Beginn garantiert akt. wird
    AktuelleZeit = Fix(Timer) - 1
    'alle Termineintrge durchlaufen ----------------------------
    On Error GoTo ErrorTerminUpdateFehler
 'On Error GoTo 0
    Set meineTerminlisteGesamt = meinTerminOrdner.Items
    meineTerminlisteGesamt.Sort "[Start]"
    meineTerminlisteGesamt.IncludeRecurrences = True
    'TEerminKAlenderBEgin auf 00:00 Uhr des Von-Tages einstellen
    
'''    TeKaBe = Me.Tag_von.Value & Me.Jahresauswahl.Value & " 00:00:00"
    TeKaBe = Format(DatumVon, "Short Date")
    'TEerminKAlenderENde auf 00:00 des nchsten Tages nach dem Bis-Tag einstellen
    
'''    TeKaEn = DateSerial(Me.Jahresauswahl, Val(Mid(Me.Tag_bis.Value, 4, 2)), Val(Left(Me.Tag_bis.Value, 2)) + 1) & " 00:00:00"
    TeKaEn = DateSerial(Year(DatumBis), Month(DatumBis), Day(DatumBis) + 1) & " 00:00:00"
    TeKaEn = Format(TeKaEn, "Short Date")
    
    
    'Zur Vorbereitung...
    '...Kontakte-/Termin-Tabellen ffnen
    Set dbs = CurrentDb
    Set rstKontakte = dbs.OpenRecordset("Kunden")
    Set rstTermine = dbs.OpenRecordset("Termine")
    
    TerminOhneKontakt_Zaehler = 0
    
    'Termine filtern:
    '   Da mit RESTRICT kein komplizierter Filter angewendet werden kann, wird erst ein Teil der
    '   Termine abgefragt und verarbeitet, und dann der nchste Teil
    
    '1.)Filter auf Termine,...
    '   ...deren Start vor dem TagVon UND deren Ende nach/am TagVon des ausgewhlten Jahres liegen
    TeKaFi = "([Start] < '" & TeKaBe & "' AND [End] >= '" & TeKaBe & "')"
    Set meineTerminliste = meineTerminlisteGesamt.Restrict(TeKaFi)
    For Each meinTermin In meineTerminliste
        'Termineigenschaften sofort auslesen und zwischenspeichern,
        'da bei Terminserien diese Werte nach dem ersten Auslesen auf
        'den Starttermin der Terminserie vom System zurckgesetzt werden...
        T_Start = meinTermin.Start
        T_Ende = meinTermin.End
        T_ID = meinTermin.EntryID
        T_Dauer = meinTermin.Duration
        T_Betreff = ""
        T_Kategorie = ""
        T_Kategorie = meinTermin.Categories
        T_Betreff = meinTermin.Subject
        If meinTermin.Sensitivity <> 0 Then
            T_Privat = True
        Else
            T_Privat = False
        End If
        If km_Erfassung = True Then
            T_Km = meinTermin.Mileage
        Else
            T_Km = ""
        End If
        If (IsNull(T_Betreff) Or Len(T_Betreff) = 0) Then T_Betreff = "(ohne Betreff)"
        
        If (IsNull(T_Kategorie) Or Len(T_Kategorie) = 0) Then
            T_Kategorie = "(ohne Kategorie)"
        Else
            If InStr(T_Kategorie, ";") Then
                'nur die erste Kategorie bernehmen
                T_Kategorie = Left(T_Kategorie, InStr(T_Kategorie, ";") - 1)
            End If
            'Hochkammas (') entfernen, da diese fr SQL bentigt werden
            While InStr(T_Kategorie, "'")
                T_Kategorie = Left(T_Kategorie, InStr(T_Kategorie, "'") - 1) & "_" & Mid(T_Kategorie, InStr(T_Kategorie, "'") + 1)
            Wend
            Trim (T_Kategorie)
        End If
        If T_Kategorie = "" Then T_Kategorie = "(ohne Kategorie)"
        
        Nummero = Nummero + 1
        NummeroAllerKalender = NummeroAllerKalender + 1
        If Fix(Timer) > AktuelleZeit Then                   'Eine Sekunde vergangen?
            'Anzeige aktualisieren
            Me.TerminNummerAktuell.Caption = Nummero
            Me.TerminAktuellAnzeigen.Caption = "[" & T_Start & "  " & T_Betreff & "]"
            Me.Repaint
            AktuelleZeit = Fix(Timer)
        End If

        FehlerCode = ""
            Termin_verarbeiten
            
        If FehlerCode <> "" Then
            'direkte Fehlerbehandlung
            If FehlerCode = "ErrorKontaktverknuepfungFehlt" Then GoTo ErrorKontaktverknuepfungFehlt
            'indirekte Fehlerbehandlung
            If FehlerCode = "ErrorKontaktNichtGefunden" Then On Error GoTo ErrorKontaktNichtGefunden
            If FehlerCode = "ErrorKontaktAnlegenFehler" Then On Error GoTo ErrorKontaktAnlegenFehler
            If FehlerCode = "ErrorKontaktUpdateFehler" Then On Error GoTo ErrorKontaktUpdateFehler
            If FehlerCode = "ErrorTerminUpdateFehler" Then On Error GoTo ErrorTerminUpdateFehler
            err.Raise FehlerNummer
        End If
          
        'auf Abbruchwunsch reagieren
        DoEvents            'auf Mausklick reagieren
        If (UpdateAbbruch = True) Then Exit For
    Next meinTermin
    'Anzeige auf den aktuellen Stand bringen
    Me.TerminNummerAktuell.Caption = Nummero
    Me.TerminAktuellAnzeigen.Caption = ""
    Me.Repaint
    'auf Abbruchwunsch reagieren -----------------------------------
    If (UpdateAbbruch = True) Then
        'Anzeige auf ABBRUCH stellen
        Me.Ergebnis_TermineAktualisieren.Caption = "Abbruch"
        'Me.Ergebnis_TermineAktualisieren.ForeColor = "32768"  ' Grn
        Me.Ergebnis_TermineAktualisieren.ForeColor = "255"    ' Rot
        Me.Pfeil_TermineAktualisieren.Visible = False
        Me.Repaint
        GoTo Ende_Button_START_Click
    Else
    'ERST im ZWEITEN Durchgang auf OK stellen!
    '    'Anzeige auf OK stellen
    '    Me.Ergebnis_TermineAktualisieren.Caption = "OK"
    '    Me.Ergebnis_TermineAktualisieren.ForeColor = "32768"  ' Grn
    '    'Me.Ergebnis_TermineAktualisieren.ForeColor = "255"    ' Rot
    '    Me.Pfeil_TermineAktualisieren.Visible = False
    '    Me.Repaint
    End If
    
    '2.)Filter auf Termine,...
    '   ...deren Start nach/am TagVon UND vor dem (Ende des ausgew. TagBis + 1) liegen
     TeKaFi = "([Start] >= '" & TeKaBe & "' AND [Start] < '" & TeKaEn & "')"
    Set meineTerminliste = meineTerminlisteGesamt.Restrict(TeKaFi)
    For Each meinTermin In meineTerminliste
        'Termineigenschaften sofort auslesen und zwischenspeichern,
        'da bei Terminserien diese Werte nach dem ersten Auslesen auf
        'den Starttermin der Terminserie vom System zurckgesetzt werden...
        T_Start = meinTermin.Start
        T_Ende = meinTermin.End
        T_ID = meinTermin.EntryID
        T_Dauer = meinTermin.Duration
        T_Betreff = ""
        T_Kategorie = ""
        T_Kategorie = meinTermin.Categories
        T_Betreff = meinTermin.Subject
        If meinTermin.Sensitivity <> 0 Then
            T_Privat = True
        Else
            T_Privat = False
        End If
        If km_Erfassung = True Then
            T_Km = meinTermin.Mileage
        Else
            T_Km = ""
        End If
        If (IsNull(T_Betreff) Or Len(T_Betreff) = 0) Then T_Betreff = "(ohne Betreff)"
        If (IsNull(T_Kategorie) Or Len(T_Kategorie) = 0) Then
            T_Kategorie = "(ohne Kategorie)"
        Else
            If InStr(T_Kategorie, ";") Then
                'nur die erste Kategorie bernehmen
                T_Kategorie = Left(T_Kategorie, InStr(T_Kategorie, ";") - 1)
            End If
            'Hochkammas (') entfernen, da diese fr SQL bentigt werden
            While InStr(T_Kategorie, "'")
                T_Kategorie = Left(T_Kategorie, InStr(T_Kategorie, "'") - 1) & "_" & Mid(T_Kategorie, InStr(T_Kategorie, "'") + 1)
            Wend
            Trim (T_Kategorie)
        End If
        Nummero = Nummero + 1
        NummeroAllerKalender = NummeroAllerKalender + 1
        If Fix(Timer) > AktuelleZeit Then
            'Anzeige aktualisieren
            Me.TerminNummerAktuell.Caption = Nummero
            Me.TerminAktuellAnzeigen.Caption = "[" & T_Start & "  " & T_Betreff & "]"
            Me.Repaint
            AktuelleZeit = Fix(Timer)
        End If
        
        FehlerCode = ""
            Termin_verarbeiten
            
        If FehlerCode <> "" Then
            'direkte Fehlerbehandlung
            If FehlerCode = "ErrorKontaktverknuepfungFehlt" Then GoTo ErrorKontaktverknuepfungFehlt
            'indirekte Fehlerbehandlung
            If FehlerCode = "ErrorKontaktNichtGefunden" Then On Error GoTo ErrorKontaktNichtGefunden
            If FehlerCode = "ErrorKontaktAnlegenFehler" Then On Error GoTo ErrorKontaktAnlegenFehler
            If FehlerCode = "ErrorKontaktUpdateFehler" Then On Error GoTo ErrorKontaktUpdateFehler
            If FehlerCode = "ErrorTerminUpdateFehler" Then On Error GoTo ErrorTerminUpdateFehler
            err.Raise FehlerNummer
        End If
          
        'auf Abbruchwunsch reagieren
        DoEvents            'auf Mausklick reagieren
        If (UpdateAbbruch = True) Then Exit For
    Next meinTermin
    'Anzeige auf den aktuellen Stand bringen
    Me.TerminNummerAktuell.Caption = Nummero
    Me.TerminAktuellAnzeigen.Caption = ""
    Me.Repaint
    'auf Abbruchwunsch reagieren -----------------------------------
    If (UpdateAbbruch = True) Then
        'Anzeige auf ABBRUCH stellen
        Me.Ergebnis_TermineAktualisieren.Caption = "Abbruch"
        'Me.Ergebnis_TermineAktualisieren.ForeColor = "32768"  ' Grn
        Me.Ergebnis_TermineAktualisieren.ForeColor = "255"    ' Rot
        Me.Pfeil_TermineAktualisieren.Visible = False
        Me.Repaint
        GoTo Ende_Button_START_Click
    Else
        'Anzeige auf OK stellen
        Me.Ergebnis_TermineAktualisieren.Caption = "OK"
        Me.Ergebnis_TermineAktualisieren.ForeColor = "32768"  ' Grn
        'Me.Ergebnis_TermineAktualisieren.ForeColor = "255"    ' Rot
        Me.Pfeil_TermineAktualisieren.Visible = False
        Me.Repaint
    End If
    
    'Zur Nachbereitung...
    '...Kontakte-/Termin-Tabellen schliessen
    rstKontakte.Close
    rstTermine.Close
    
    
    
    
    
    
    
'    End If                      'TerminOrdner ohne Termine
'    rstKalenderOrdner.MoveNext
'Loop                            'Durchlauf der 'aktivierten' KalenderOrdner
    
    
    
    
    
    
    
    'Abbruch nach dem Einlesen nicht mehr ermglichen
    Me.Button_Placebo.SetFocus        'Focus von der STOP-Schaltflche nehmen!
    Me.Button_STOP.Enabled = False
    Me.Repaint
    
    'Termine mit Lschmarkierung versehen =============================================
    'gelschte Termine, die nicht berechnet werden mssen: mit Lschmarkierung versehen
    Me.Pfeil_TerminePruefen.Visible = True
    Nummero = 0
    NummeroTermin = 0
    Me.Meldungsfeld.Caption = "Termine prfen..."
    Me.PruefenNummerAktuell.Caption = NummeroTermin
    Me.PruefenNummerGesamt.Caption = Nummero
    Me.Repaint
    'Absprung auf Unterprogramm --------------------------------
    On Error GoTo ErrorTerminPruefenFehler
 'On Error GoTo 0
    Termine_loeschen
    'Anzeige auf OK stellen -------------------------------------
    Me.Ergebnis_TerminePruefen.Caption = "OK"
    Me.Ergebnis_TerminePruefen.ForeColor = "32768"  ' Grn
    'Me.Ergebnis_TermineLoeschen.ForeColor = "255"    ' Rot
    Me.Pfeil_TerminePruefen.Visible = False
    Me.Repaint
    
    
'========>      Filter anpassen !!!!!!!!!!!!!!!       !!!!!!!!!!!!!!!!
'
'Beispiel: FilterKmPreis = "[gilt_ab] <= #" & Format(rstTermine!Start, "mm") & "/" & Format(rstTermine!Start, "Dd") & "/" & Format(rstTermine!Start, "yyyy") & "#"
'



    'Kalerderbersichten erstellen =====================================================
    '(als gelscht markierte Termine werden nicht wieder eingetragen)
    Me.Pfeil_Kalender.Visible = True
    Nummero = 0
    NummeroTermin = 0
    Me.Meldungsfeld.Caption = "Kalenderbersicht erstellen/aktualisieren..."
    Me.KalenderAktuell.Caption = NummeroTermin
    Me.KalenderGesamt.Caption = Nummero
    Me.Repaint
    ' 1 Sekunde abziehen, damit die Anzeige zu Beginn garantiert akt. wird
    AktuelleZeit = Timer - 1
    'alle Termineintrge durchlaufen ----------------------------
    On Error GoTo ErrorKalenderFehler
    KalenderJahr = Year(Me.Datum_von.Value)
    'nach Terminen suchen, die mit dem ausgewhlten Zeitraum zu tun haben...
    FilterTermin = ""
    'nur Termine, deren Beginn oder Ende im angegeben Zeitraum liegen,
    'oder Beginn und Ende vor und nach dem Zeitraum liegen
    ' (
    '   ([Start] < TeKaBe AND [Ende] >= TeKaBe)
    '  OR
    '   ([Start] >= TeKaBe AND [Start] < TeKaEn)
    ' )
    FilterTermin = "SELECT * FROM Termine WHERE (" & _
        "([Start] < #" & Format(TeKaBe, "mm") & "/" & Format(TeKaBe, "Dd") & "/" & Format(TeKaBe, "yyyy") & "# AND [Ende] >= #" & Format(TeKaBe, "mm") & "/" & Format(TeKaBe, "Dd") & "/" & Format(TeKaBe, "yyyy") & "#)" & _
        " OR " & _
        "([Start] >= #" & Format(TeKaBe, "mm") & "/" & Format(TeKaBe, "Dd") & "/" & Format(TeKaBe, "yyyy") & "# AND [Start] < #" & Format(TeKaEn, "mm") & "/" & Format(TeKaEn, "Dd") & "/" & Format(TeKaEn, "yyyy") & "#)"
    'Filter um aktuelle Kalendernummer ergnzen
    FilterTermin = FilterTermin & " AND ([lfd_Nr_Kalender] = " & AktKalender & ")"
'''''        "(" & _
'''''            "(([S_Jahr] = " & KalenderJahr & ") AND ([S_Monat] >= 1) AND ([S_Jahr] = " & KalenderJahr & ") AND ([S_Monat] <= 12))" & _
'''''            " OR " & _
'''''            "(([E_Jahr] = " & KalenderJahr & ") AND ([E_Monat] >= 1) AND ([E_Jahr] = " & KalenderJahr & ") AND ([E_Monat] <= 12))" & _
'''''            " OR " & _
'''''            "(([S_Jahr] < " & KalenderJahr & ") AND ([E_Jahr] > " & KalenderJahr & "))" & _
'''''            " OR "
'''''    'Sonderfall MonatVon = 1    (Details siehe Filter zum Rechnungslauf!)
'''''        FilterTermin = FilterTermin & _
'''''            "(" & _
'''''                "([S_Jahr] < " & KalenderJahr & ") AND (([E_Jahr] > " & KalenderJahr & ") OR (([E_Jahr] = " & KalenderJahr & ") AND ([E_Monat] > 1)))" & _
'''''            ")"
'''''    'schlieende Klammer
'''''    FilterTermin = FilterTermin & _
'''''        ")"
    'nur Termine, die keine Lschmarkierung besitzen
    'FilterTermin = FilterTermin & " AND ([geloescht] = False)"
        ' Obige Filtereinstellung wurde deaktiviert, damit die Kalender der Kunden,
        ' bei denen alle Termine des Jahres gelscht wurden, auch bereinigt werden.
        ' Es drfen dann weiter unten nur die Termine in den Kalender eingetragen werden,
        ' die keine Lschmarkierung haben.
    'Termine nach Kunden und Terminbeginn aufsteigend sortieren
    FilterTermin = FilterTermin & ") ORDER BY Termine.lfd_Nr_Kunde, Termine.Start;"
    Set rstTermine = dbs.OpenRecordset(FilterTermin)
    rstTermine.Requery
    If (rstTermine.RecordCount <> 0) Then rstTermine.MoveLast
    If (rstTermine.RecordCount = 0) Then
        Me.KalenderAktuell.Caption = "0"
        Me.KalenderGesamt.Caption = "0"
        Me.Repaint
    Else
        'alle gefundenen Termine durchgehen
        Me.KalenderGesamt.Caption = rstTermine.RecordCount
        KalenderKundeZuletzt = 0
        rstTermine.MoveFirst
        Do While Not rstTermine.EOF
            'Zhler und Anzeige aktualisieren
            NummeroTermin = NummeroTermin + 1
            If Fix(Timer) > AktuelleZeit Then
                'den 1. Termin und dann jede Sekunde anzeigen
                Me.KalenderAktuell.Caption = NummeroTermin
                Me.Repaint
                AktuelleZeit = Fix(Timer)
            End If
            KalenderKunde = rstTermine!lfd_Nr_Kunde
            
'da das Kalender-Raster nicht mehr Kunden-bezogen ist, sind die folgenden Zeilen berflssig:
'            'wenn Kunde zum vorherigen Termin anders: neue, leere Kalenderbersicht generieren
'            If (KalenderKunde <> KalenderKundeZuletzt) Then
'                TerminEinAusTragen = False              '=AUStragen
'                KalenderGenerieren
'            End If

'            'nur Termine ohne Lschmarkierung in den Kalender eintragen
'            If (rstTermine!geloescht = False) Then
'                TerminEinAusTragen = True               '=EINtragen
                TerminInDenKalender
'            End If
            'Kundennummer dieses Termines merken
            KalenderKundeZuletzt = KalenderKunde
            'nchster Termin
            rstTermine.MoveNext
        Loop        'gefundene Termine durchgehen
    End If          '(RecordCount = 0 ?)
    rstTermine.Close
    'Anzeige auf OK stellen -------------------------------------
    Me.KalenderAktuell.Caption = NummeroTermin
    Me.Ergebnis_Kalender.Caption = "OK"
    Me.Ergebnis_Kalender.ForeColor = "32768"  ' Grn
    'Me.Ergebnis_Kalender.ForeColor = "255"    ' Rot
    Me.Pfeil_Kalender.Visible = False
    Me.Repaint
    
    'Termine entgltig lschen ========================================================
    'nachdem die Kalender aktualisiert wurden: nicht mehr bentigte Termine lschen
    Me.Pfeil_TermineLoeschen.Visible = True
    Nummero = 0
    NummeroTermin = 0
    Me.Meldungsfeld.Caption = "Gelschte Termine kennzeichnen..."
    Me.TerminLoeschenAktuell.Caption = NummeroTermin
    Me.TerminLoeschenGesamt.Caption = Nummero
    Me.Repaint
    'Absprung auf Unterprogramm --------------------------------
    On Error GoTo ErrorTerminLoeschenFehler
    Termine_entfernen
    'Anzeige auf OK stellen -------------------------------------
    Me.Ergebnis_TermineLoeschen.Caption = "OK"
    Me.Ergebnis_TermineLoeschen.ForeColor = "32768"  ' Grn
    'Me.Ergebnis_TermineLoeschen.ForeColor = "255"    ' Rot
    Me.Pfeil_TermineLoeschen.Visible = False
    Me.Repaint
    
    
    
    
    
    
    
    End If                      'TerminOrdner ohne Termine
    rstKalenderOrdner.MoveNext
Loop                            'Durchlauf der 'aktivierten' KalenderOrdner
    
    
    
    
    
    
    
    'Kalkulationslauf =========================================================================
    If Me.Kaestchen_Kalkulationslauf.Value <> 0 Then        'egal, ob wahr "1" oder "-1" ergibt
        On Error GoTo ErrorTerminKalkulationFehler
        'Variablen initialisieren
        TestlaufAnsichtGeschlossen = False
        ReEchtlauf = False
        ReTestlauf = True
        ReUngedrucktAlle = False
        ReLaufArt = 5
        ReKopieAnzahl = 1
        ReKopieZeitpunkt = 1
        KalkulationAusOutlookUebernahme = True
            Rechnungslauf
        KalkulationAusOutlookUebernahme = False
    End If              'Kalkulationslauf
    
    
    
    
    
    
    
    'Gehrt eigentlich ins Modul "Kategorieverarbeitung":
    
    'Einstellung prfen, ob Kategorien ohne interne Bezge wieder gelscht werden sollen
    '===================================================================================
    If KatLeereLoeschen = True Then
        Me.Meldungsfeld.Caption = "Unbenutze Kategorien wieder lschen..."
        Me.Repaint
        '--------------------------------------------------------------------------------------------
        ' Alle Kategorien, die nirgendwo benutzt werden, sollen wieder gelscht werden.
        ' Dazu mssen alle Tabellen, die einen Verweis auf die "lfd_Nr" der Tabelle "Kategorien" haben,
        ' geprft werden, ob die jeweilige Kategorie-Nr. dort verwendet wird. Dies wird durch die
        ' Abfragen "Abf_Kat__Anz_Termine" (Abf_Kat__Anz_...) realisiert.
        ' Dazu wird die eine Abfrage von hinten nach vorne durchlaufen und die jeweilige
        ' Kategorie-Nr. in den anderen Abfragen gesucht. Wenn alle Abfragen fr die jew. Kategorie-Nr.
        ' null Datenstze ergibt, kann die Kategorie gelscht werden.
        '
        ' ACHTUNG:
        ' --------
        ' Wenn die Kategorien in einer weiteren/neuen Tabelle verwendet werden, muss fr diese Tabelle
        ' eine neue Abfrage erstellt/gespeichert und hier in diese Routine eingebaut werden!
        ' > Die DUMMY-Kategorie darf NICHT gelscht werden! <
        '--------------------------------------------------------------------------------------------
'On Error GoTo 0
        Set dbs = CurrentDb
        Set rstKategorien = dbs.OpenRecordset("Kategorien")
        Set rstKatPreise = dbs.OpenRecordset("Abf_Kat__Anz_Preise")
        Set rstKatRechnungen = dbs.OpenRecordset("Abf_Kat__Anz_Rechnungen")
        Set rstKatTermineKalender = dbs.OpenRecordset("Abf_Kat__Anz_TermineKalender")
        Set rstKatTermineGeloescht = dbs.OpenRecordset("Abf_Kat__Anz_TermineGeloescht")
        Set rstKatTermine = dbs.OpenRecordset("Abf_Kat__Anz_Termine")
        If rstKatTermine.RecordCount > 0 Then
            rstKatTermine.MoveLast          ' auffllen
            'rstKatTermine.MoveFirst        ' kein MoveFirst, da die Suche von hinten nach vorne luft!
            Do While (Not rstKatTermine.BOF) And (rstKatTermine!Anzahl = 0)
                KatLoeschText = "[lfd_Nr]=" & rstKatTermine!lfd_Nr
                'Preise
                rstKatPreise.FindFirst (KatLoeschText)
                If (rstKatPreise.NoMatch) Or (rstKatPreise!Anzahl = 0) Then
                    'Rechnungen
                    rstKatRechnungen.FindFirst (KatLoeschText)
                    If (rstKatRechnungen.NoMatch) Or (rstKatRechnungen!Anzahl = 0) Then
                        'Termine_Kalender
                        rstKatTermineKalender.FindFirst (KatLoeschText)
                        If (rstKatTermineKalender.NoMatch) Or (rstKatTermineKalender!Anzahl = 0) Then
                            'Termine_gelscht
                            rstKatTermineGeloescht.FindFirst (KatLoeschText)
                            If (rstKatTermineGeloescht.NoMatch) Or (rstKatTermineGeloescht!Anzahl = 0) Then
                                'Kategorie lschen:
                                rstKategorien.FindFirst (KatLoeschText)
                                If Not rstKategorien.NoMatch Then
                                    'nur lschen, wenn es NICHT die DUMMY-Kategorie ist!
                                    If rstKategorien!Kategorie_ID <> "0123456789DUMMY9876543210" Then
                                        rstKategorien.Delete
                                    End If
                                End If
                            End If
                        End If
                    End If
                End If
                'vorhergehenden Datensatz auswhlen
                rstKatTermine.MovePrevious
            Loop    ' rstKatTermine
        End If
        rstKatPreise.Close
        rstKatRechnungen.Close
        rstKatTermineKalender.Close
        rstKatTermineGeloescht.Close
        rstKatTermine.Close
        rstKategorien.Close
    End If
    
    
    
    
    
    
    
    
End If                  'Anzahl "aktiver" KalenderOrdner=0 ?
    
    
    
    
    
    
    
    'Anzeige mit Erfolgsmeldung versehen ------------------------
    Me.Meldungsfeld.Caption = "Termine und Adressen wurden erfolgreich aktualisiert."
    'If Val(Me.TerminNummerAktuell.Caption) > 0 Then
    If NummeroAllerKalender > 0 Then
        'Me.Meldungsfeld.Caption = Me.Meldungsfeld.Caption & vbNewLine & _
        '    "Es wurde(n) " & Val(Me.TerminNummerAktuell.Caption) & " Termin(e) im angegeben Zeitraum gefunden."
        Me.Meldungsfeld.Caption = Me.Meldungsfeld.Caption & vbNewLine & _
            "Es wurde(n) " & NummeroAllerKalender & " Termin(e) im angegeben Zeitraum gefunden."
    End If
    Me.Repaint
        
        
    
Ende_Button_START_Click:
    
    'evtl. Fehlerbeschreibung merken ----------------------------
    If err.Number <> 0 Then
        FehlerMeldung = "Fehler # " & Str(err.Number) & " wurde ausgelst von " _
            & err.Source & vbNewLine & err.Description
    End If
    
    'Anzeige evtl. mit Abbruchmeldung versehen ------------------
    If (UpdateAbbruch = True) Then
        Me.Meldungsfeld.Caption = "Die Aktualisierung der Termine und Adressen wurde vom Benutzer abgebrochen."
    End If
    Me.Repaint
    
    'Fehlerbehandlung ausschalten -------------------------------
    On Error Resume Next
    
    'Aktualisierung protokollieren ------------------------------
    rstAktualisierungen.Bookmark = rstAktualisierungen.LastModified
    rstAktualisierungen.Edit
    rstAktualisierungen!Ende = Now()
    If (Len(FehlerMeldung) > 0) Then
        rstAktualisierungen!Status = "Fehler"
        rstAktualisierungen!Systemtext = FehlerMeldung
    Else
        If (TerminOhneKontakt_Zaehler > 0) And (TerminOhneKontakt_verarbeiten = "W") Then
            rstAktualisierungen!Status = "Warnung"
            rstAktualisierungen!Systemtext = "Es wurden " & TerminOhneKontakt_Zaehler & " Termine ohne Kontaktzuordnung bernommen."
        Else
            rstAktualisierungen!Status = "OK"
            rstAktualisierungen!Systemtext = " "
        End If
    End If
    If (UpdateAbbruch = True) Then rstAktualisierungen!Status = "Abbruch"
    rstAktualisierungen!Fehlertext = Me.Meldungsfeld.Caption
    rstAktualisierungen.Update
    rstAktualisierungen.Close
    
    'geffnete Tabellen schlieen -------------------------------
    Set rstAktualisierungen = Nothing
    Set rstEinstellungen = Nothing
    Set rstKontakte = Nothing
    Set rstTermine = Nothing
    Set dbs = Nothing
    Set olkAnw = Nothing
    
    'Button freigeben/sperren -----------------------------------
    Me.TerminAktuellAnzeigen.Caption = ""
    Me.Button_Schliessen.Enabled = True
    Me.Button_Schliessen.SetFocus
    If (Len(FehlerMeldung) > 0) Then
        Me.Button_START.Enabled = False
    Else
        Me.Button_START.Enabled = True
    End If
        'wenn der START-Button nicht generell nach Aufruf gesperrt bleiben soll,
        'bitte die folgende Zeile lschen:
            Me.Button_START.Enabled = False
    Me.Button_STOP.Enabled = False
    Me.Button_Fehlermeldung.Enabled = True
    Me.Aktualisierungen_drucken.Enabled = True
    Me.Repaint
    
    'Beendigungsmeldung ausgeben
    Beep
    If (UpdateAbbruch = True) Then
        MsgBox "Die Aktualisierung wurde abgebrochen." & vbNewLine & vbNewLine & _
            "ACHTUNG:" & vbNewLine & "Durch den Abbruch wurden neue Termine nicht in die internen Kalender eingetragen " & _
            "und gelschte Termine nicht ausgetragen." & vbNewLine & vbNewLine & _
            "Sie sollten diesen Datenstand nicht fr eine Abrechnung nutzen!", vbOKOnly + vbExclamation, "Abbruch"
    Else
        If (Len(FehlerMeldung) > 0) Then
            If Me.Meldungsfeld.Caption = "In den Einstellungen gibt es keinen 'aktiven' Kalender." Then
            ' "Fehler"-Meldung abfangen:
                MsgBox "In den Einstellungen gibt es keinen 'aktiven' Kalender.", vbInformation + vbOKOnly, "Kein Kalender aktiv..."
            Else
                MsgBox "Beim Aktualisieren ist ein Fehler aufgetreten!" & vbNewLine & vbNewLine & _
                    "Sie sollten diesen Datenstand nicht fr eine Abrechnung nutzen!", vbOKOnly + vbCritical, "Fehler"
            End If
        Else
            If (TerminOhneKontakt_Zaehler > 0) And (TerminOhneKontakt_verarbeiten = "W") Then
                Me.Meldungsfeld.Caption = "Es wurde(n) " & TerminOhneKontakt_Zaehler & " Termin(e) ohne Kontaktzuordnung bernommen."
                Me.Ergebnis_TermineAktualisieren.Caption = "Warnung"
                Me.Ergebnis_TermineAktualisieren.ForeColor = "255"    ' Rot
                MsgBox "Kategorien/Termine/Adressen wurden aktualisiert." & vbNewLine & vbNewLine & _
                "ACHTUNG:" & vbNewLine & "Es wurde(n) " & TerminOhneKontakt_Zaehler & _
                " Termin(e) bernommen, denen kein Kontakt zugeordnet ist.", vbOKOnly + vbExclamation, "Warnung"
            Else
                MsgBox "Kategorien, Termine und Adressen wurden aktualisiert.", vbOKOnly + vbInformation, "Fertig"
            End If
        End If
    End If
    
    
    Exit Sub
    

'Fehlerbehandlung ===================================================================

ErrorVariablenInitialisierung:
        Me.Meldungsfeld.Caption = "Erforderlicher Programmspeicher fr Variablen konnte nicht reserviert/eingerichtet werden!"
        GoTo Ende_Button_START_Click

ErrorOutlookVerbindung:
        Me.Meldungsfeld.Caption = "Es konnte keine Verbindung zu Ihrem Outlook hergestellt werden!"
        Me.Ergebnis_TermineFiltern.Caption = "Fehler"
        Me.Ergebnis_TermineFiltern.ForeColor = "255"    ' Rot
        GoTo Ende_Button_START_Click

ErrorTerminPostfach:
        Me.Meldungsfeld.Caption = "Das unter Einstellungen angegebene Postfach fr die Termine wurde in Ihrem Outlook nicht gefunden!"
        Me.Ergebnis_TermineFiltern.Caption = "Fehler"
        Me.Ergebnis_TermineFiltern.ForeColor = "255"    ' Rot
        GoTo Ende_Button_START_Click
        
ErrorKontaktPostfach:
        Me.Meldungsfeld.Caption = "Das unter Einstellungen angegebene Postfach fr die Kontakte wurde in Ihrem Outlook nicht gefunden!"
        Me.Ergebnis_TermineFiltern.Caption = "Fehler"
        Me.Ergebnis_TermineFiltern.ForeColor = "255"    ' Rot
        GoTo Ende_Button_START_Click

ErrorTerminUnterordner1:
        Me.Meldungsfeld.Caption = "Der unter Einstellungen angegebene Unterordner 1 fr die Termine wurde in Ihrem Outlook nicht gefunden!"
        Me.Ergebnis_TermineFiltern.Caption = "Fehler"
        Me.Ergebnis_TermineFiltern.ForeColor = "255"    ' Rot
        GoTo Ende_Button_START_Click

ErrorKontaktUnterordner1:
        Me.Meldungsfeld.Caption = "Der unter Einstellungen angegebene Unterordner 1 fr die Kontakte wurde in Ihrem Outlook nicht gefunden!"
        Me.Ergebnis_TermineFiltern.Caption = "Fehler"
        Me.Ergebnis_TermineFiltern.ForeColor = "255"    ' Rot
        GoTo Ende_Button_START_Click

ErrorTerminUnterordner2:
        Me.Meldungsfeld.Caption = "Der unter Einstellungen angegebene Unterordner 2 fr die Termine wurde in Ihrem Outlook nicht gefunden!"
        Me.Ergebnis_TermineFiltern.Caption = "Fehler"
        Me.Ergebnis_TermineFiltern.ForeColor = "255"    ' Rot
        GoTo Ende_Button_START_Click

ErrorKontaktUnterordner2:
        Me.Meldungsfeld.Caption = "Der unter Einstellungen angegebene Unterordner 2 fr die Kontakte wurde in Ihrem Outlook nicht gefunden!"
        Me.Ergebnis_TermineFiltern.Caption = "Fehler"
        Me.Ergebnis_TermineFiltern.ForeColor = "255"    ' Rot
        GoTo Ende_Button_START_Click

ErrorTerminUnterordner3:
        Me.Meldungsfeld.Caption = "Der unter Einstellungen angegebene Unterordner 3 fr die Termine wurde in Ihrem Outlook nicht gefunden!"
        Me.Ergebnis_TermineFiltern.Caption = "Fehler"
        Me.Ergebnis_TermineFiltern.ForeColor = "255"    ' Rot
        GoTo Ende_Button_START_Click

ErrorKontaktUnterordner3:
        Me.Meldungsfeld.Caption = "Der unter Einstellungen angegebene Unterordner 3 fr die Kontakte wurde in Ihrem Outlook nicht gefunden!"
        Me.Ergebnis_TermineFiltern.Caption = "Fehler"
        Me.Ergebnis_TermineFiltern.ForeColor = "255"    ' Rot
        GoTo Ende_Button_START_Click

'ErrorKontakteAktualisieren:
'        Me.Meldungsfeld.Caption = "Beim Einlesen/Aktualisieren der Adressen ist ein Fehler aufgetreten!"
'        Me.Ergebnis_AdressenAktualisieren.Caption = "Fehler"
'        Me.Ergebnis_AdressenAktualisieren.ForeColor = "255"    ' Rot
'        GoTo Ende_Button_START_Click

ErrorKontaktverknuepfungFehlt:
        Me.Meldungsfeld.Caption = "Der Termin [" & meinTermin.Start & " - " & meinTermin.End & "] enthlt keine Verknpfung zu einem Adresseintrag!"
        Me.Ergebnis_TermineAktualisieren.Caption = "Fehler"
        Me.Ergebnis_TermineAktualisieren.ForeColor = "255"    ' Rot
        FehlerMeldung = "(Keine Systeminformationen zu diesem Fehler.)"     '"Fllen", damit in der Db "Fehler" vermerkt wird
        GoTo Ende_Button_START_Click

ErrorKontaktNichtGefunden:
        'ACHTUNG bei Anlagen:  "Attachmets...DisplayName" oder "Links...Name"
        'alte Outlook-97-Version: 8.02
        If (meinTermin.OutlookVersion = "8.02") Then
            Me.Meldungsfeld.Caption = "Der beim Termin [" & meinTermin.Start & " - " & meinTermin.End & "] angegebene Kontakt [" & meinTermin.Attachments.Item(1).DisplayName & "] wurde in Outlook nicht gefunden!"
        Else
            Me.Meldungsfeld.Caption = "Der beim Termin [" & meinTermin.Start & " - " & meinTermin.End & "] angegebene Kontakt [" & meinTermin.Links.Item(1).Name & "] wurde in Outlook nicht gefunden!"
        End If
        Me.Meldungsfeld.Caption = Me.Meldungsfeld.Caption & " Wurde die Adresse in Outlook gelscht oder verschoben?"
        Me.Ergebnis_TermineAktualisieren.Caption = "Fehler"
        Me.Ergebnis_TermineAktualisieren.ForeColor = "255"    ' Rot
        GoTo Ende_Button_START_Click

ErrorKontaktAnlegenFehler:
        'ACHTUNG bei Anlagen:  "Attachmets...DisplayName" oder "Links...Name"
        'alte Outlook-97-Version: 8.02
        If (meinTermin.OutlookVersion = "8.02") Then
            Me.Meldungsfeld.Caption = "Bei Neuaufnahme des Kontaktes [" & meinTermin.Attachments.Item(1).DisplayName & "] in die eigene Datenbank ist ein Fehler aufgetreten!"
        Else
            Me.Meldungsfeld.Caption = "Bei Neuaufnahme des Kontaktes [" & meinTermin.Links.Item(1).Name & "] in die eigene Datenbank ist ein Fehler aufgetreten!"
        End If
        Me.Ergebnis_TermineAktualisieren.Caption = "Fehler"
        Me.Ergebnis_TermineAktualisieren.ForeColor = "255"    ' Rot
        GoTo Ende_Button_START_Click

ErrorKontaktUpdateFehler:
        'ACHTUNG bei Anlagen:  "Attachmets...DisplayName" oder "Links...Name"
        'alte Outlook-97-Version: 8.02
        If (meinTermin.OutlookVersion = "8.02") Then
            Me.Meldungsfeld.Caption = "Beim Aktualisieren des Kontaktes [" & meinTermin.Attachments.Item(1).DisplayName & "] in die eigene Datenbank ist ein Fehler aufgetreten!"
        Else
            Me.Meldungsfeld.Caption = "Beim Aktualisieren des Kontaktes [" & meinTermin.Links.Item(1).Name & "] in die eigene Datenbank ist ein Fehler aufgetreten!"
        End If
        Me.Ergebnis_TermineAktualisieren.Caption = "Fehler"
        Me.Ergebnis_TermineAktualisieren.ForeColor = "255"    ' Rot
        GoTo Ende_Button_START_Click

ErrorTerminUpdateFehler:
        Me.Meldungsfeld.Caption = "Beim Aktualisieren des Termines [" & meinTermin.Subject & ": " & meinTermin.Start & "] in die eigene Datenbank ist ein Fehler aufgetreten!"
        Me.Ergebnis_TermineAktualisieren.Caption = "Fehler"
        Me.Ergebnis_TermineAktualisieren.ForeColor = "255"    ' Rot
        GoTo Ende_Button_START_Click
             
ErrorTerminPruefenFehler:
        Me.Meldungsfeld.Caption = "Beim Prfen des Termines [" & meinTermin.Subject & ": " & meinTermin.Start & "] in der eigenen Datenbank ist ein Fehler aufgetreten!"
        Me.Ergebnis_TerminePruefen.Caption = "Fehler"
        Me.Ergebnis_TerminePruefen.ForeColor = "255"    ' Rot
        GoTo Ende_Button_START_Click

ErrorTerminLoeschenFehler:
        Me.Meldungsfeld.Caption = "Beim Aktualisieren/Lschen des Termines [" & meinTermin.Subject & ": " & meinTermin.Start & "] in der eigenen Datenbank ist ein Fehler aufgetreten!"
        Me.Ergebnis_TermineLoeschen.Caption = "Fehler"
        Me.Ergebnis_TermineLoeschen.ForeColor = "255"    ' Rot
        GoTo Ende_Button_START_Click

ErrorKalenderFehler:
        Me.Meldungsfeld.Caption = "Beim Erstellen/Aktualisieren der Kalenderbersichten ist ein Fehler aufgetreten!"
        Me.Ergebnis_Kalender.Caption = "Fehler"
        Me.Ergebnis_Kalender.ForeColor = "255"    ' Rot
        GoTo Ende_Button_START_Click
        
ErrorTerminKalkulationFehler:
        Me.Meldungsfeld.Caption = "Beim Kalkulationslauf ist ein Fehler aufgetreten!"
        GoTo Ende_Button_START_Click

End Sub

Private Sub Button_STOP_Click()
    If MsgBox("Mchten Sie die Aktualisierung der Termine und Adressen wirklich abbrechen?", vbYesNo + vbQuestion + vbDefaultButton2, "Abbruch") = vbYes Then
        UpdateAbbruch = True
    End If
End Sub

Private Sub Form_Load()
    On Error Resume Next
    DoCmd.Close acForm, "Kategorien", acSaveYes
    DoCmd.Close acForm, "Kunden", acSaveYes
    DoCmd.Close acForm, "Rechnungen_Uebersicht", acSaveYes
    
    DoCmd.Close acForm, "Bitte_warten", acSaveYes
End Sub

Private Sub Form_Open(Cancel As Integer)
    'aktuelles Datumsformat des Systems einstellen
    Me.Datum_von.InputMask = "00/00/0099;0;_"
    Me.Datum_bis.InputMask = "00/00/0099;0;_"
    Me.Datum_von.Format = "Short Date"
    Me.Datum_bis.Format = "Short Date"

    'Fehlerbeschreibung zurcksetzen
    FehlerMeldung = ""
    
    'Einstellen des Jahres
'''    Me.Jahresauswahl.DefaultValue = Year(Now())
    
    'Einstellen der Tage vom 1. bis Letzten des aktuellen Monats
'''    Me.Tag_von.Value = "01." & Format(Month(Now()), "00") & "."
'''    Me.Tag_bis.Value = Format(Day(DateSerial(Year(Now()), Month(Now()) + 1, 1 - 1)), "00") & "." & Format(Month(Now()), "00") & "."
    Me.Datum_von.Value = Format(DateSerial(Year(Now()), Month(Now()), 1), "Short Date")
    Me.Datum_bis.Value = Format(DateSerial(Year(Now()), Month(Now()) + 1, 1 - 1), "Short Date")

'''    'gesperrte Jahren beachten
'''    If Me.Jahresauswahl < Me.NichtVorJahr Then
'''        Me.Jahresauswahl.DefaultValue = Me.NichtVorJahr
'''        Me.Monat_bis.DefaultValue = 1
'''    End If
End Sub

Private Sub Jahresauswahl_AfterUpdate()
    Dim DatumText As String
    
    'gesperrte Jahren beachten
    If Me.Jahresauswahl < Me.NichtVorJahr Then
        Me.Jahresauswahl.DefaultValue = Me.NichtVorJahr
    End If
    
    'Prfen, ob Jahreswahl immernoch gltige Datumswerte mit Von- und Bis-Tag ergibt,
    'z. B. bei einem 29.02.
    Tag_von_LostFocus
    Tag_bis_LostFocus
    
End Sub

Private Sub Jahresauswahl_BeforeUpdate(Cancel As Integer)
    'gesperrte Jahren beachten
    If Me.Jahresauswahl < Me.NichtVorJahr Then
        MsgBox "Gem Ihren Einstellungen drfen keine Termine der Jahre vor " & Me.NichtVorJahr.Value & " eingelesen werden.", vbCritical + vbOKOnly, "Jahr gesperrt"
    End If
End Sub

Private Sub Tag_bis_LostFocus()
    Dim DatumText As String
    
    'Fehler, wenn Monat nicht zwischen 1 und 12 liegt
    If (Val(Mid(Me.Tag_bis.Value, 4, 2)) < 1) Or (Val(Mid(Me.Tag_bis.Value, 4, 2)) > 12) Then
        MsgBox "Der eingegebene Monat liegt nicht im Bereich von '01' bis '12'.", vbOKOnly + vbExclamation, "Fehler in [bis]"
        UpdateAbbruch = True        'Auswertung beim Haken-Button
        Exit Sub
    End If
    
    'Prfen, ob eingegebener Wert mit dem Jahr ein gltiges Datum ergibt
    '1. DatumText in der Form: "Monat Tag, Jahr", um den Monat EINdeutig zu kennzeichnen
    DatumText = Val(Mid(Me.Tag_bis.Value, 4, 2)) & " " & Val(Left(Me.Tag_bis.Value, 2)) & ", " & Me.Jahresauswahl
    '2. Prfung
    If IsDate(DatumText) = False Then
        MsgBox "Die Kombination von 'Bis:' mit der Jahresauswahl ergibt kein gltiges Datum.", vbOKOnly + vbExclamation, "Fehler"
        UpdateAbbruch = True        'Auswertung beim Haken-Button
        Exit Sub
    End If
    
    'So wird dann das richtige Datum gebildet (!):
    'DateSerial(Me.Jahresauswahl, Val(Mid(Me.Tag_bis.Value, 4, 2)), Val(Left(Me.Tag_bis.Value, 2)))

End Sub

Private Sub Tag_von_LostFocus()
    Dim DatumText As String
    
    'Fehler, wenn Monat nicht zwischen 1 und 12 liegt
    If (Val(Mid(Me.Tag_von.Value, 4, 2)) < 1) Or (Val(Mid(Me.Tag_von.Value, 4, 2)) > 12) Then
        MsgBox "Der eingegebene Monat liegt nicht im Bereich von '01' bis '12'.", vbOKOnly + vbExclamation, "Fehler in [von]"
        UpdateAbbruch = True        'Auswertung beim Haken-Button
        Exit Sub
    End If
    
    'Prfen, ob eingegebener Wert mit dem Jahr ein gltiges Datum ergibt
    '1. DatumText in der Form: "Monat Tag, Jahr", um den Monat EINdeutig zu kennzeichnen
    DatumText = Val(Mid(Me.Tag_von.Value, 4, 2)) & " " & Val(Left(Me.Tag_von.Value, 2)) & ", " & Me.Jahresauswahl
    '2. Prfung
    If IsDate(DatumText) = False Then
        MsgBox "Die Kombination von 'Von:' mit der Jahresauswahl ergibt kein gltiges Datum.", vbOKOnly + vbExclamation, "Fehler"
        UpdateAbbruch = True        'Auswertung beim Haken-Button
        Exit Sub
    End If
    
    'So wird dann das richtige Datum gebildet (!):
    'DateSerial(Me.Jahresauswahl, Val(Mid(Me.Tag_von.Value, 4, 2)), Val(Left(Me.Tag_von.Value, 2)))

End Sub
